import numpy as np 
import sys
import os 
import random 
from ClassifierTwoSample.ClassifierTwoSample import ClassifierTwoSampleTest
from Options import * 
sys.path.append(os.getcwd() + "/CreateDataset/")
sys.path.append(os.getcwd() + "/ClassifierTwoSample/")
from Dataset import * 
from ClassifierTwoSample import *
from Utility import *


def main():

	"""
	Set up parameters
	"""
	args = parser.parse_args()
	print('========================= Performing a %s Two-sample Test with %s query scheme, Sep: %.2f, noise: %.2f, budget: %d =============================='%(args.TestType, args.QS, args.Sep, args.noise_var, args.Budget))

	"""
	Set random seed 
	"""
	
	print('======================= Random number with seed %d ========================='%args.Trial)
	random.seed(args.Trial); 
	np.random.seed(args.Trial)

	"""
	Bulid directory
	"""
	print('========================= Build directory ==============================')
	StatsPath, FigurePath = GetDirectory(args)

	if args.RunTest == 1:
		"""
		Acquire data
		"""
		print('======================= Acquiring data ==============================')
		MatchPairExpData, EnrichmentClsTestingData = GetMatchDataByDistance(args)
			
		"""
		Two-Sample Test
		"""
		ClassifierTwoSampleTest(args, MatchPairExpData, EnrichmentClsTestingData, StatsPath, FigurePath)

if __name__ == '__main__':
	main()